# Dify：零代码 AI 应用开发平台

> 用可视化方式构建你的 AI 应用



你好，我是鱼皮。

在前面的文章中，我们学习了零代码平台，可以用 Bolt.new、百度秒哒快速生成网站和应用。但如果你想做的是 AI 应用，比如智能客服、知识库问答、AI 助手，该用什么工具呢？

这篇文章，我会介绍 **Dify**，一个专门用来开发 AI 应用的零代码平台。通过可视化的方式，你可以快速构建功能强大的 AI 应用，而且完全不需要写代码。

让我通过实际操作，带你了解 Dify 的使用方法，同时也会顺便讲解一些 AI 的核心概念。



## 一、什么是 Dify？

[Dify](https://dify.ai/) 是一个开源的 AI 应用开发平台，可以让你通过可视化的方式构建 AI 应用。

它和 Bolt.new 的区别是什么？

Bolt.new 主要用来生成普通的网站和应用，比如个人主页、电商网站等。而 Dify 专注于 AI 应用，比如：

- 智能客服机器人
- 知识库问答系统
- AI 写作助手
- 文档分析工具
- AI 工作流自动化

Dify 提供了可视化的配置界面，你可以通过拖拽的方式搭建 AI 工作流，配置大模型、设置提示词、添加知识库等，不需要写代码就能做出功能强大的 AI 应用。

![](https://pic.yupi.icu/1/853427c8123decb5ea3d163ae3bb8ab635d95e92f7ee14a2e51e54df06e94fd8.png)



## 二、快速上手 Dify

让我通过一个实际例子，带你快速上手 Dify。



### 1、创建 AI 应用

首先进入 [Dify 平台](https://dify.ai/)，注册账号并登录。然后创建一个 AI 应用，进入到 AI 对话界面。

![](https://pic.yupi.icu/1/1743560753186-1e9452e6-0d38-4070-b369-c674bc418c91.png)



### 2、选择大模型

首次使用时，我们要选择 **大模型**（LLM）。

**大模型是 AI 的大脑**，是指具有海量参数的人工智能模型，通过大规模的预训练获得广泛的知识和能力。

![](https://pic.yupi.icu/1/1743560803824-ab33d9d9-e994-45e5-8190-fc104e679747.png)

不同大模型的参数规模、处理能力、接受的对话长度是不一样的。比如 Claude Opus 4.5 编程能力很强，Gemini 3 Pro 支持超长上下文，DeepSeek 完全免费。

![](https://pic.yupi.icu/1/1743560841202-c37cde5b-0b25-4ebb-adff-3ab66af35d75.png)

选择大模型后，我们可以设置参数来调整大模型的输出。比如 **温度** 可以控制模型输出的随机性：

- 温度值越高，模型输出越随机多样（适合创意写作）
- 温度值越低，输出越确定保守（适合专业问答）

![](https://pic.yupi.icu/1/1743560855583-7efaebb7-3552-4a5b-9787-adbb9acaddc6.png)



### 3、设置提示词

下面我们来和 AI 进行对话。输入给 AI 的内容我们称为 **提示词（Prompt）**，用来引导模型生成特定内容或执行特定任务。

提示词的质量直接决定了 AI 输出的准确度。提示词又可以分为两种：

- 系统提示词：整体约束 AI 输出的内容，需要提前设置
- 用户提示词：用户自主输入的内容，随用随输

![](https://pic.yupi.icu/1/1743560920031-d86572e4-b09e-46b4-8aa8-c734a96bec44.png)

比如我想做一个编程助手，可以在系统提示词中设置：

```
你是一位专业的编程助手，擅长 Python、JavaScript、Java 等语言。
回答问题时要简洁明了，提供代码示例。
```

然后用户就可以直接问：“怎么用 Python 读取文件？”



### 4、理解 Token

我们进行一次对话后，会发现对话下方展示了 “花费 Token”。

![](https://pic.yupi.icu/1/1743561058442-beebd2ac-94a0-4f00-8e56-f819822247e1.png)

看到 “花费” 很多同学就慌了，啥是 Token 啊？Token 贵不贵啊？

**Token 是大语言模型处理文本的基本单位**，可能是单词或标点符号。模型的输入和输出都是按 Token 计算的，一般 Token 越多，成本越高、并且输出速度越慢。

不同模型的计费都不太一样，一般 100 万 Token 要几十块钱。你可以通过一些在线的 Token 计算工具来估算成本。

![](https://pic.yupi.icu/1/1743561097206-472514a9-3d13-4408-b222-2207b00f611a.png)

不过不用太担心，日常使用的话，成本不会很高。而且很多平台都有免费额度。



### 5、添加知识库（RAG）

有时，大模型可能缺少了某些信息。比如让 AI 总结 [鱼皮写的《保姆级写简历指南》](https://www.codefather.cn/course/cv)，它给的信息就不准确，因为它没有读过这篇文章。

这时候我们可以开启知识库功能，背后是 **RAG（检索增强生成）** 技术，来利用外部知识库给 AI 补充知识。

![](https://pic.yupi.icu/1/1743561648847-337df359-2e2a-4e05-bec6-fdff52b3be1d.png)

首先创建知识库，上传知识文档：

![](https://pic.yupi.icu/1/1743561783744-1ddce7bb-802e-4feb-9e8f-7e0a83b4ad98.png)

然后对文本进行切分，可以自己设置分块的规则：

![](https://pic.yupi.icu/1/1743561816205-22494e52-c011-49fe-8537-3b7f0f441a51.png)

接下来利用 **Embedding（嵌入）** 技术，将文本转换为向量表示，并写入到向量数据库中。

用户向 AI 提问时，会将问题转换成向量，从知识库中检索和问题相关的信息，再将这些信息和问题一起输入大模型进行处理，使大模型的回答更准确。

![](https://pic.yupi.icu/1/1743561872916-7971c368-14bd-49c2-9bd9-604973f469e3.png)

这样一来，AI 就能基于你提供的知识库来回答问题了。



### 6、发布和调用

好，这样我们的 AI 应用就做完了。可以发布给别人用，也可以通过 **API 接口**，在自己的代码程序中通过网络请求来调用。

![](https://pic.yupi.icu/1/1743561915955-ad27735a-c927-4207-b769-03fda32081b6.png)



## 三、AI 智能体和工作流

刚刚我们只是做了个简单的聊天助手。但实际上，Dify 还支持更强大的功能 —— **AI 智能体**。

智能体是能够感知环境、进行推理、制定计划、做出决策并自主采取行动来实现目标的 AI 系统。

![](https://pic.yupi.icu/1/1743561972671-9c7ad13e-a467-4a08-ba14-711d4640939c.png)

我们可以给智能体提供 **工具**，比如网页搜索、查询天气、调用数据库等等，让智能体完成更复杂的任务。

安装工具后，提供给智能体，它就会在需要的时候使用这个工具。比如从网上检索到内容，进行总结后再回复。这样一来，AI 的应用范围和能力边界将会是无限大。

![](https://pic.yupi.icu/1/1743562005435-e5ece3f2-5f4b-4729-b490-a1e51f1f006e.png)

当然，如果你用的 AI 大模型不够聪明，它可能不会用工具。所以我建议给智能体选用思考能力更强的推理模型。

有些模型会使用 **思维链（CoT）** 和 **ReAct** 技术，让模型先思考问题、推理分析并提出行动计划，然后再行动，再基于结果进一步推理。并且中间步骤和思考过程是公开可见的，让我们能够理解模型是如何得出结论的。

![](https://pic.yupi.icu/1/1743562152661-80fabf5f-07a4-4463-a980-67da980f0ede.png)

有时，单一的智能体并不能完成我们的任务，比如自动生成 100 个短视频、自动做个游戏并发布上线。

这时我们可以使用 **智能体工作流**（Agentic Workflow），可以通过规划和编排，让智能体自由搭配功能，自动化实现各种复杂的任务。有点像可视化编程。

![](https://pic.yupi.icu/1/1743562195750-57a3b344-4282-4279-bd71-510f60fc17c6.png)



## 四、MCP 服务集成

最后再分享一个很火的概念，叫 **MCP（Model Context Protocol）模型上下文协议**，用于实现 AI 与外部工具或数据的标准化交互。

![](https://pic.yupi.icu/1/1743562215479-a19f8b1c-0190-41b4-8a2f-f508b24e74a7.png)

简单来说，利用 MCP 服务，我们可以更方便地给 AI 集成不同的工具和数据，增强 AI 应用的功能。

首先安装 MCP Agent 策略，让智能体支持调用 MCP：

![](https://pic.yupi.icu/1/1743562275496-34bcb486-235d-4d97-bc5a-cdf00f59cff7.png)

然后可以去 [MCP 大全网站](https://mcp.so/) 找到我们需要的 MCP 服务，比如查询当前时间。

![](https://pic.yupi.icu/1/1743562325916-dbef66dc-d0d1-4a60-9bed-68691c462677.png)

再回到智能体工作流中，填写 MCP 服务器地址、调用 MCP 的指令和查询条件等信息，AI 就可以在需要的时候向 MCP 发送请求来获取数据了。

![](https://pic.yupi.icu/1/1743562400230-79c99317-98f1-4579-8884-a5bf53623683.png)



## 五、其他 AI应用开发平台

除了 Dify，还有一些其他的 AI 应用开发平台也值得了解。

### Coze

[Coze](https://www.coze.com/) 是字节跳动推出的 AI 应用开发平台，提供了大量的插件，方便完成应用开发。

Coze 的优势是零代码、可视化流程，而且提供了很多预置的插件和模板，上手很快。适合个人和轻量应用。



### 阿里云百炼

[阿里云百炼](https://bailian.console.aliyun.com/) 是企业级 AI 应用开发平台，支持 RAG 知识库、流程编排等功能。

百炼的优势是企业级能力，提供了可视化的流程编排功能，不用写代码就能构建复杂的 AI 工作流。而且和阿里云的其他服务深度集成，适合企业用户。



### 怎么选择？

如果你是个人开发者或者没有编程基础，想快速做个 AI 应用，Dify 和 Coze 都是不错的选择。

如果你是企业用户或者 Java 开发者，需要更强的稳定性和企业级功能，可以考虑阿里云百炼。

我自己主要用阿里云百炼，毕竟作为一名以 Java 后端为主的全栈程序员，阿里在国内 Java 生态的地位无可撼动，他们推出的 Spring AI Alibaba 框架和自家 AI 的集成度更高，能快速开发出完整的 AI 应用。



## 六、Dify 实战技巧

在使用 Dify 的过程中，我总结了一些实用技巧。

1、选择合适的大模型

不同的任务适合不同的模型。如果是创意写作，可以选择 GPT-4 或 Claude；如果是代码生成，Claude 的编程能力更强；如果预算有限，可以选择 DeepSeek 或 Gemini Flash。

2、优化提示词

提示词的质量直接影响 AI 的输出。建议：

- 明确角色定位（比如 “你是一位专业的……”）
- 清楚说明任务要求
- 提供具体的示例
- 设置输出格式

3、善用知识库

如果你的 AI 应用需要基于特定的知识回答问题，一定要使用知识库功能。把相关的文档、资料上传到知识库，AI 的回答会准确很多。

4、测试和迭代

做好 AI 应用后，一定要多测试。尝试各种不同的问题，看看 AI 的回答是否符合预期。发现问题就调整提示词或者知识库，不断迭代优化。

5、利用工作流

对于复杂的任务，可以使用工作流功能。把任务拆解成多个步骤，每个步骤完成一个小任务，最后组合起来。这样更容易控制，也更容易调试。



## 写在最后

看到这里，相信你已经对 Dify 和 AI 应用开发有了基本的了解。

**用 Dify 做 AI 应用，真的很简单。** 不需要写代码，只需要配置一下，就能做出功能强大的 AI 应用。

而且在使用 Dify 的过程中，你也会逐渐理解 AI 的核心概念，比如大模型、提示词、Token、RAG、智能体等。这些概念不仅在 Dify 中有用，在其他 AI 工具中也是通用的。

建议接下来你亲自尝试用 Dify 做一个简单的 AI 应用，比如一个编程问答助手、一个文档总结工具、或者一个知识库问答系统，慢慢你就会发现 AI 应用开发的乐趣。



## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
